// PhoneDlg.cpp : implementation file
//

//********************************************************************************
//If you should have any comments, suggestions or improvements to these samples,
//we welcome you to contact us at SampleCode@melissadata.com also please visit our
//developers bulletin board at forum.melissadata.com.
//********************************************************************************

#include "stdafx.h"
#include "Phone.h"
#include "PhoneDlg.h"
#include <atlbase.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CPhoneApp theApp;

    /********************** LICENSE STRINGS **********************
          To unlock the full functionality of Phone Object,       
      please call a sales representative at 1-800-MELISSA ext. 3  
              (1-800-635-4772 x3) for a license string.           
           Without a valid license string, Phone Object will      
                    only verify Nevada Area Codes                
                  REPLACE "DEMO" with LICENSE STRING                    

      SetLicenseString will also check for a valid license in the 
      MDPHONE_LICENSE(Environment) variable. This allows you to  
      modify the license without recompiling the project    
    *************************************************************/

const CString dLICENSE="DEMO";

    /********************** DATA FILE PATHS **********************
    *    This sample sets the data file path to the installation *
    * default.  If you installed your Melissa Data data files to *
    * a different path, enter that location it below.            *
    * The Data Files Directory must contain the following files: *
    * mdAddr.dat,mdPhone.dat, mdPhone.idx and ZIPNPA.TXT.        *
    *************************************************************/

const CString dFILELOC="C:\\Program Files\\Melissa DATA\\DQT\\Data";


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
  CAboutDlg();

// Dialog Data
  //{{AFX_DATA(CAboutDlg)
  enum { IDD = IDD_ABOUTBOX };
  //}}AFX_DATA

  // ClassWizard generated virtual function overrides
  //{{AFX_VIRTUAL(CAboutDlg)
  protected:
  virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
  //}}AFX_VIRTUAL

// Implementation
protected:
  //{{AFX_MSG(CAboutDlg)
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
  //{{AFX_DATA_INIT(CAboutDlg)
  //}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CAboutDlg)
  //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
  //{{AFX_MSG_MAP(CAboutDlg)
    // No message handlers
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPhoneDlg dialog

CPhoneDlg::CPhoneDlg(CWnd* pParent /*=NULL*/)
  : CDialog(CPhoneDlg::IDD, pParent)
{
  //{{AFX_DATA_INIT(CPhoneDlg)
  m_Phone = _T("");
  m_Zip = _T("");
  m_Area_Code = _T("");
  m_Build_Num = _T("");
  m_City_Name = _T("");
  m_Fips = _T("");
  m_County_Name = _T("");
  m_Path = _T("");
  m_DB_Date = _T("");
  m_Suffix = _T("");
  m_Results = _T("");
  m_State_Name = _T("");
  m_Prefix = _T("");
  m_New_Area_Code = _T("");
  m_Longitude = _T("");
  m_Latitude = _T("");
  m_Init_Err_Str = _T("");
  m_Extention = _T("");
  m_Distance = _T("");
    m_MSA = _T("");
    m_PMSA = _T("");
  m_Time_Zone = _T("");
  m_Time_Zone_Code = _T("");
  m_Calc_Distance = _T("");
  m_Bear_Long_1 = _T("");
  m_Bear_Long_2 = _T("");
  m_Bear_Lat_1 = _T("");
  m_Bear_Lat_2 = _T("");
  m_Bearing = _T("");
  m_Dist_Lat_1 = _T("");
  m_Dist_Lat_2 = _T("");
  m_Dist_Long_1 = _T("");
  m_Dist_Long_2 = _T("");
    m_Validation = _T("");
  m_ExchangeType = _T("");
  m_PhoneType = _T("");

  //}}AFX_DATA_INIT
  // Note that LoadIcon does not require a subsequent DestroyIcon in Win32
  m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

  phone = NULL;
  phoneCreated = phoneInit = false;

  //Initialize the COM library
  CoInitialize(0);

  m_Path = theApp.GetProfileString("Paths", "PhoneData");

}

CPhoneDlg::~CPhoneDlg()
{
  //Release the PhoneCheck
  if (phone)
  {
    phone->Release();
    phone = NULL;
  }

  //Uninitializes the COM library
  CoUninitialize();
}

void CPhoneDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CPhoneDlg)
  DDX_Text(pDX, IDC_PHONE, m_Phone);
  DDX_Text(pDX, IDC_ZIP, m_Zip);
  DDX_Text(pDX, IDC_AREA_CODE, m_Area_Code);
  DDX_Text(pDX, IDC_BUILD_NUMBER, m_Build_Num);
  DDX_Text(pDX, IDC_CITY_NAME, m_City_Name);
  DDX_Text(pDX, IDC_COUNTY_FIPS, m_Fips);
  DDX_Text(pDX, IDC_COUNTY_NAME, m_County_Name);
  //DDX_Text(pDX, IDC_DATA_PATH, m_Path);
  DDX_Text(pDX, IDC_DATABASE_DATE, m_DB_Date);
  DDX_Text(pDX, IDC_SUFFIX, m_Suffix);
  DDX_Text(pDX, IDC_STATE_NAME, m_State_Name);
  DDX_Text(pDX, IDC_PREFIX, m_Prefix);
  DDX_Text(pDX, IDC_NEW_AC, m_New_Area_Code);
  DDX_Text(pDX, IDC_LONGITUDE, m_Longitude);
  DDX_Text(pDX, IDC_LATITUDE, m_Latitude);
  DDX_Text(pDX, IDC_INIT_ERR_STR, m_Init_Err_Str);
  DDX_Text(pDX, IDC_EXT, m_Extention);
  DDX_Text(pDX, IDC_DISTANCE, m_Distance);
  DDX_Text(pDX, IDC_TIMEZONE, m_Time_Zone);
  DDX_Text(pDX, IDC_TIMEZONECODE, m_Time_Zone_Code);
  DDX_Text(pDX, IDC_MSA, m_MSA); 
  DDX_Text(pDX, IDC_PMSA, m_PMSA);
  DDX_Text(pDX, IDC_DISTANCE2, m_Calc_Distance);
  DDX_Text(pDX, IDC_BEAR_LONG_1, m_Bear_Long_1);
  DDX_Text(pDX, IDC_BEAR_LONG_2, m_Bear_Long_2);
  DDX_Text(pDX, IDC_BEAR_LAT_1, m_Bear_Lat_1);
  DDX_Text(pDX, IDC_BEAR_LAT_2, m_Bear_Lat_2);
  DDX_Text(pDX, IDC_BEARING, m_Bearing);
  DDX_Text(pDX, IDC_DIST_LAT_1, m_Dist_Lat_1);
  DDX_Text(pDX, IDC_DIST_LAT_2, m_Dist_Lat_2);
  DDX_Text(pDX, IDC_DIST_LONG_1, m_Dist_Long_1);
  DDX_Text(pDX, IDC_DIST_LONG_2, m_Dist_Long_2);
  DDX_Text(pDX, IDC_RESULTS, m_Results);
    DDX_Text(pDX, IDC_VALIDATION, m_Validation);
    DDX_Text(pDX, IDC_EXCHANGETYPE, m_ExchangeType);
    DDX_Text(pDX, IDC_PHONETYPE, m_PhoneType);
  //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPhoneDlg, CDialog)
  //{{AFX_MSG_MAP(CPhoneDlg)
  ON_WM_SYSCOMMAND()
  ON_WM_PAINT()
  ON_WM_QUERYDRAGICON()
  ON_BN_CLICKED(IDC_BROWSE_PATH, OnBrowsePath)
  ON_BN_CLICKED(IDC_CORRECT, OnCorrect)
  ON_BN_CLICKED(IDC_LOOKUP, OnLookup)
  ON_BN_CLICKED(IDC_COMP_DIST, OnCompDist)
  ON_BN_CLICKED(IDC_COMP_BEARING, OnCompBearing)
  ON_BN_CLICKED(IDC_COPY_LATLNG1, OnCopyLatlng1)
  ON_BN_CLICKED(IDC_COPY_LATLNG2, OnCopyLatlng2)
  ON_BN_CLICKED(IDC_CLEAR, OnClear)
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPhoneDlg message handlers

BOOL CPhoneDlg::OnInitDialog()
{
  CDialog::OnInitDialog();

  // Add "About..." menu item to system menu.

  // IDM_ABOUTBOX must be in the system command range.
  ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
  ASSERT(IDM_ABOUTBOX < 0xF000);

  CMenu* pSysMenu = GetSystemMenu(FALSE);
  if (pSysMenu != NULL)
  {
    CString strAboutMenu;
    strAboutMenu.LoadString(IDS_ABOUTBOX);
    if (!strAboutMenu.IsEmpty())
    {
      pSysMenu->AppendMenu(MF_SEPARATOR);
      pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
    }
  }

  // Set the icon for this dialog.  The framework does this automatically
  //  when the application's main window is not a dialog
  SetIcon(m_hIcon, TRUE);     // Set big icon
  SetIcon(m_hIcon, FALSE);    // Set small icon

  try
  {
    // New COM - Phone Object
    phone = new IPhoneCheckPtr(__uuidof(PhoneCheck));

/*************************************************************************
    //This is where we enter or License String to unlock the DEMO Version.
***************************************************************************/
    phone->SetLicenseString(bstr_t(dLICENSE));

    phoneCreated = true;
    initPhone();
  }
  catch(const _com_error &e)
  {
    AfxMessageBox(e.ErrorMessage());
  }

  return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPhoneDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
  if ((nID & 0xFFF0) == IDM_ABOUTBOX)
  {
    CAboutDlg dlgAbout;
    dlgAbout.DoModal();
  }
  else
  {
    CDialog::OnSysCommand(nID, lParam);
  }
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPhoneDlg::OnPaint()
{
  if (IsIconic())
  {
    CPaintDC dc(this); // device context for painting

    SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

    // Center icon in client rectangle
    int cxIcon = GetSystemMetrics(SM_CXICON);
    int cyIcon = GetSystemMetrics(SM_CYICON);
    CRect rect;
    GetClientRect(&rect);
    int x = (rect.Width() - cxIcon + 1) / 2;
    int y = (rect.Height() - cyIcon + 1) / 2;

    // Draw the icon
    dc.DrawIcon(x, y, m_hIcon);
  }
  else
  {
    CDialog::OnPaint();
  }
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPhoneDlg::OnQueryDragIcon()
{
  return (HCURSOR) m_hIcon;
}

void CPhoneDlg::OnCancel()
{

  CDialog::OnCancel();
}

void CPhoneDlg::OnBrowsePath()
{
  //This is where we set up and open a file browse box
  CFileDialog dlg(TRUE, NULL, "*.dat");

  if ( dlg.DoModal() )
  {
    char drive[4], dir[_MAX_PATH];

    //This is where we split our path in to seperate tokens
    _splitpath((LPCTSTR)dlg.GetPathName(), drive, dir, NULL, NULL);
    m_Path = drive;
    m_Path += dir;

    UpdateData(FALSE);

    //We are writing the path to the registry for future use
    theApp.WriteProfileString("Paths", "PhoneData", (LPCTSTR)m_Path);
  }

}

void CPhoneDlg::OnCorrect()
{
  //Needed to handle the BSTR's
  CComBSTR retStr;

  UpdateData();

  //If the PhoneCheck has not yet been initialized
  if ( phoneInit == false )
  {
    if (initPhone() == false)
    {
      AfxMessageBox("Failed to initialize the Phone component.");
      return;
    }

  }

  //Let's convert our input
  _bstr_t pPhone((LPCTSTR)m_Phone);
  _bstr_t pZip=((LPCTSTR)m_Zip);//used to be _variant_t



  //Time to call the CorrectPhone method
  if (phone->CorrectAreaCode(pPhone, pZip) == 0)
  {
    retStr = (LPCOLESTR)phone->GetResults();
    m_Results = retStr.Detach();

    m_Area_Code.Empty();
    m_City_Name.Empty();
    m_Fips.Empty();
    m_County_Name.Empty();
    m_Suffix.Empty();
    m_State_Name.Empty();
    m_Prefix.Empty();
    m_New_Area_Code.Empty();
    m_Longitude.Empty();
    m_Latitude.Empty();
    m_Extention.Empty();
    m_Distance.Empty();
        m_MSA.Empty();
        m_PMSA.Empty();
      m_Time_Zone.Empty();
      m_Time_Zone_Code.Empty();
  }
  else
  {
    m_Area_Code.Empty();
    m_City_Name.Empty();
    m_Fips.Empty();
    m_County_Name.Empty();
    m_Suffix.Empty();
    m_Results.Empty();
    m_State_Name.Empty();
    m_Prefix.Empty();
    m_New_Area_Code.Empty();
    m_Longitude.Empty();
    m_Latitude.Empty();
    m_Extention.Empty();
    m_Distance.Empty();
    m_MSA.Empty();
        m_PMSA.Empty();
      m_Time_Zone.Empty();
      m_Time_Zone_Code.Empty();

    retStr = (LPCOLESTR)phone->GetAreaCode();
    m_Area_Code = retStr.Detach();

    retStr = (LPCOLESTR)phone->GetPrefix();
    m_Prefix = retStr.Detach();

    retStr = (LPCOLESTR)phone->GetSuffix();
    m_Suffix = retStr.Detach();

    retStr = (LPCOLESTR)phone->GetExtension();
    m_Extention = retStr.Detach();

    retStr = (LPCOLESTR)phone->GetNewAreaCode();
    m_New_Area_Code = retStr.Detach();

    retStr = (LPCOLESTR)phone->GetResults();
    m_Results = retStr.Detach();
  }

  UpdateData(FALSE);
}

void CPhoneDlg::OnLookup()
{
  //Needed to handle the BSTR's
  CComBSTR retStr;

  UpdateData();

  //If the PhoneCheck has not yet been initialized
  if ( phoneInit == false )
  {
    if (initPhone() == false)
    {
      AfxMessageBox("Failed to initialize the Phone component.");
      return;
    }

  }

  //Let's convert our input
  _bstr_t pPhone((LPCTSTR)m_Phone);

  _variant_t pZip((LPCTSTR)m_Zip);


  //Time to call the Lookup method
  if (phone->Lookup(pPhone, pZip) == 0)
  {
    retStr = (LPCOLESTR)phone->GetResults();
    m_Results = retStr.Detach();

    m_Area_Code.Empty();
    m_City_Name.Empty();
    m_Fips.Empty();
    m_County_Name.Empty();
    m_Suffix.Empty();
    m_State_Name.Empty();
    m_Prefix.Empty();
    m_New_Area_Code.Empty();
    m_Longitude.Empty();
    m_Latitude.Empty();
    m_Extention.Empty();
    m_Distance.Empty();
    m_MSA.Empty();
        m_PMSA.Empty();
      m_Time_Zone.Empty();
      m_Time_Zone_Code.Empty();
    m_Validation.Empty();
      m_ExchangeType.Empty();
      m_PhoneType.Empty();
  }
  else
  {
    retStr = (LPCOLESTR)phone->GetAreaCode();
    m_Area_Code = retStr.Detach();

    retStr = (LPCOLESTR)phone->GetPrefix();
    m_Prefix = retStr.Detach();

    retStr = (LPCOLESTR)phone->GetSuffix();
    m_Suffix = retStr.Detach();

    retStr = (LPCOLESTR)phone->GetExtension();
    m_Extention = retStr.Detach();

    retStr = (LPCOLESTR)phone->GetResults();
    m_Results = retStr.Detach();

    if ((strstr(m_Results,"PS01")!=0) || (strstr(m_Results,"PS02")!=0))
    {
      if (strstr(m_Results,"PS01")!=0)
                    m_Validation = "Validated to 10 Digits";
      else if (strstr(m_Results,"PS02")!=0)
                    m_Validation = "Validated to 7 Digits";

      if (strstr(m_Results,"PS07")!=0)
               m_ExchangeType = "Cellular";
            if (strstr(m_Results,"PS08")!=0)
               m_ExchangeType = "Land Line";
            else if (strstr(m_Results,"PS09")!=0)
               m_ExchangeType  = "Voip";

        if (strstr(m_Results,"PS10")!=0)
               m_PhoneType = "Residential";
            if (strstr(m_Results,"PS11")!=0)
               m_PhoneType = "Business";
            if (strstr(m_Results,"PS12")!=0)
               m_PhoneType = "Small/Home Office";



    }

    retStr = (LPCOLESTR)phone->GetNewAreaCode();
    m_New_Area_Code = retStr.Detach();

    retStr = (LPCOLESTR)phone->GetLatitude();
    m_Latitude = retStr.Detach();

    retStr = (LPCOLESTR)phone->GetLongitude();
    m_Longitude = retStr.Detach();

    retStr = (LPCOLESTR)phone->GetDistance();
    m_Distance = retStr.Detach();

    retStr = (LPCOLESTR)phone->GetCountyName();
    m_County_Name = retStr.Detach();

    retStr = (LPCOLESTR)phone->GetCountyFips();
    m_Fips = retStr.Detach();

    retStr = (LPCOLESTR)phone->GetDistance();
    m_Distance = retStr.Detach();

    retStr = (LPCOLESTR)phone->Getcity();
    m_City_Name = retStr.Detach();

    retStr = (LPCOLESTR)phone->Getstate();
    m_State_Name = retStr.Detach();

        retStr = (LPCOLESTR)phone->GetMsa();
    m_MSA = retStr.Detach();

        retStr = (LPCOLESTR)phone->GetPmsa();
    m_PMSA = retStr.Detach();

        retStr = (LPCOLESTR)phone->GetTimeZone();
    m_Time_Zone = retStr.Detach();

        retStr = (LPCOLESTR)phone->GetTimeZoneCode();
    m_Time_Zone_Code = retStr.Detach();

  }

  UpdateData(FALSE);
}

void CPhoneDlg::OnCompDist()
{
  COleDateTime date;
  CComBSTR ccbString, retStr;
  CComVariant result;

  UpdateData();

  //If the PhoneCheck has not yet been initialized
  if ( phoneInit == false )
  {
    if (initPhone() == false)
    {
      AfxMessageBox("Failed to initialize the Phone component.");
      return;
    }
  }

  //This is the ComputeDistance method
  CComVariant lat_1((LPCTSTR)m_Dist_Lat_1);
  CComVariant lat_2((LPCTSTR)m_Dist_Lat_2);
  CComVariant long_1((LPCTSTR)m_Dist_Long_1);
  CComVariant long_2((LPCTSTR)m_Dist_Long_2);

  result = phone->ComputeDistance(lat_1, long_1, lat_2, long_2);
  result.ChangeType(VT_BSTR, NULL);
  m_Calc_Distance = result.bstrVal;

  UpdateData(FALSE);

}

void CPhoneDlg::OnCompBearing()
{
  COleDateTime date;
  CComBSTR ccbString, retStr;
  CComVariant result;

  UpdateData();

  //If the Phone Object has not yet been initialized
  if ( phoneInit == false )
  {
    if (initPhone() == false)
    {
      AfxMessageBox("Failed to initialize the Phone component.");
      return;
    }
  }

  //This is the ComputeBearing method
  CComVariant lat_1((LPCTSTR)m_Dist_Lat_1);
  CComVariant lat_2((LPCTSTR)m_Dist_Lat_2);
  CComVariant long_1((LPCTSTR)m_Dist_Long_1);
  CComVariant long_2((LPCTSTR)m_Dist_Long_2);

  result = phone->ComputeBearing(lat_1, long_1, lat_2, long_2);
  result.ChangeType(VT_BSTR, NULL);
  m_Bearing = result.bstrVal;

  UpdateData(FALSE);

}

void CPhoneDlg::OnCopyLatlng1()
{
  m_Bear_Lat_1 = m_Dist_Lat_1 = m_Latitude;
  m_Bear_Long_1 = m_Dist_Long_1 = m_Longitude;
  UpdateData(FALSE);

}

void CPhoneDlg::OnCopyLatlng2()
{
  m_Bear_Lat_2 = m_Dist_Lat_2 = m_Latitude;
  m_Bear_Long_2 = m_Dist_Long_2 = m_Longitude;
  UpdateData(FALSE);

}

bool CPhoneDlg::initPhone()
{
  COleDateTime date;
  CComBSTR ccbString;


  if ( phoneCreated == false )
    return false;

  UpdateData();
  m_Path=dFILELOC;
  m_Phone="7028965154";
  m_Zip="89119";
  //Here is where we call the Initialize method
  if (phone->Initialize((LPCTSTR)m_Path) != 0)
  {
    // Error -- so let's find out what went wrong with a simple call to the
    // GetInitializeErrorString method
    ccbString = (LPCOLESTR)phone->GetInitializeErrorString();

    //Pass the Error string back from a BSTR to a CString
    m_Init_Err_Str = ccbString.Detach();

    return false;
  }

  //the initialization was successful.

  // A call to the GetDatabaseDate method
  date = phone->GetDatabaseDate();

  //Just a little Date manipulation so we can view the Date
  m_DB_Date.Format("%d/%d/%d", date.GetMonth(), date.GetDay(), date.GetYear());

  // A simple call to the GetBuildNumber method
  ccbString = (LPCOLESTR)phone->GetBuildNumber();

  //BSTR to CString
  m_Build_Num = ccbString.Detach();

  //Just to show you the Error string returned from a successful Initialization
  ccbString = (LPCOLESTR)phone->GetInitializeErrorString();

  //BSTR to CString
  m_Init_Err_Str = ccbString.Detach();

  phoneInit = true;
  UpdateData(FALSE);



  return true;
}

void CPhoneDlg::OnClear()
{
  m_Phone.Empty();
  m_Zip.Empty();
  m_Area_Code.Empty();
  m_City_Name.Empty();
  m_Fips.Empty();
  m_County_Name.Empty();
  m_Suffix.Empty();
  m_Results.Empty();
  m_State_Name.Empty();
  m_Prefix.Empty();
  m_New_Area_Code.Empty();
  m_Longitude.Empty();
  m_Latitude.Empty();
  m_Extention.Empty();
  m_Distance.Empty();
  m_MSA.Empty();
    m_PMSA.Empty();
  m_Time_Zone.Empty();
  m_Time_Zone_Code.Empty();
  m_Calc_Distance.Empty();
  m_Bear_Long_1.Empty();
  m_Bear_Long_2.Empty();
  m_Bear_Lat_1.Empty();
  m_Bear_Lat_2.Empty();
  m_Bearing.Empty();
  m_Dist_Lat_1.Empty();
  m_Dist_Lat_2.Empty();
  m_Dist_Long_1.Empty();
  m_Dist_Long_2.Empty();

  UpdateData(FALSE);

}
